local super = require "NumberFormatter"

PercentFormatter = super:new()

local defaults = {
    decimals = 0,
    groupings = true,
}

local nilDefaults = {
}

function PercentFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function PercentFormatter:getFormatter()
    return NumberStringFormatter:percent()
end

function PercentFormatter:getArguments()
    return {
        self:getProperty('decimals'),
        1,
        self:getProperty('groupings'),
    }
end

function PercentFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    inspector:addHook(self:getPropertyHook('groupings'), 'groupings')
    list:add(inspector)
    return list
end

return PercentFormatter
